<?php

namespace App\Http\Controllers;

use App\Sifarnici\Marka;
use App\Sifarnici\ModelAuta;
use App\Sifarnici\Boja;
use App\Sifarnici\BojaEnterijera;
use App\Sifarnici\BrojSedista;
use App\Sifarnici\BrojVrata;
use App\Sifarnici\EmisionaKlasa;
use App\Sifarnici\GodinaProizvodnje;
use App\Sifarnici\Gorivo;
use App\Sifarnici\IdVrstaOglasa;
use App\Sifarnici\Karoserija;
use App\Sifarnici\Klima;
use App\Sifarnici\MaterijalEnterijera;
use App\Sifarnici\Menjac;
use App\Sifarnici\Ostecenje;
use App\Sifarnici\Pogon;
use App\Sifarnici\Poreklo;
use App\Sifarnici\StranaVolana;
use App\Sifarnici\TipVozila;
use App\Sifarnici\Zamena;
use App\Sifarnici\Registracija;

use http\Env\Request;
use League\Fractal;
use League\Fractal\Manager;

class sifarniciController extends Controller
{
    public function getMarka()
    {
        $fractal = new Manager();
        $marke = Marka::all();

        $resource = new Fractal\Resource\Collection($marke, function (Marka $marka){

            return [
                'id' => (int)$marka->id,
                'vrijednost'=>(string)$marka->vrijednost,
                'links'=> [
                    'self'=>'/marka/' .$marka->id
                ]
                ];
        });
        return $fractal->createData($resource)->toJson();
    }

    public function getModel()
    {
        $fractal = new Manager();
        $modeli = ModelAuta::all();

        $resource = new Fractal\Resource\Collection($modeli, function (ModelAuta $model){

            return [
                'id' => (int)$model->id,
                'marka_id' =>(int)$model->marka_id,
                'vrijednost'=>(string)$model->vrijednost,
                'links'=> [
                    'self'=>'/marka/' .$model->id
                ]
                ];
        });
        return $fractal->createData($resource)->toJson();
    }

    public function getMarkaModel() 
    {
        $fractal = new Manager();
        $marke = Marka::all();
        $modeli = ModelAuta::all();

        $resource = new Fractal\Resource\Collection($modeli, function (ModelAuta $model){
            return [
                'id' => (int)$model->id,
                'marka' =>Marka::where('id', $model->marka_id)->pluck('vrijednost')->first(),
                'vrijednost'=>(string)$model->vrijednost,
                'links'=> [
                    'self'=>'/marka/' .$model->id
                ]
                ];
        });
        return $fractal->createData($resource)->toJson();
    }

    public function getBoja()
    {
        $fractal = new Manager();
        $boje = Boja::all();

        $resource = new Fractal\Resource\Collection($boje, function (Boja $boja){
            return [
            'id'=> (int)$boja->id,
            'vrijednost'=>(string)$boja->vrijednost,
            'links'=> [
                'self' =>'/boja/' .$boja->id
            ]
            ];
        });
        return $fractal->createData($resource)->toJson();
    }

    public function getBojaEnterijera()
    {
        $fractal = new Manager();
        $bojeEnterijera = BojaEnterijera::all();

        $resource = new Fractal\Resource\Collection($bojeEnterijera, function (BojaEnterijera $bojaEnterijera){
            return [
            'id'=> (int)$bojaEnterijera->id,
            'vrijednost'=>(string)$bojaEnterijera->vrijednost,
            'links'=> [
                'self' =>'/bojaEnterijera/' .$bojaEnterijera->id
            ]
            ];
        });
        return $fractal->createData($resource)->toJson();
    }

    public function getBrojSedista()
    {
        $fractal = new Manager();
        $brojSedista = BrojSedista::all();

        $resource = new Fractal\Resource\Collection($brojSedista, function (BrojSedista $brojSediste){
            return [
            'id'=> (int)$brojSediste->id,
            'vrijednost'=>(string)$brojSediste->vrijednost,
            'links'=> [
                'self' =>'/brojSediste/' .$brojSediste->id
            ]
            ];
        });
        return $fractal->createData($resource)->toJson();
    }

    public function getBrojVrata()
    {
        $fractal = new Manager();
        $brojVrata = BrojVrata::all();

        $resource = new Fractal\Resource\Collection($brojVrata, function (BrojVrata $_brojVrata){
            return [
            'id'=> (int)$_brojVrata->id,
            'vrijednost'=>(string)$_brojVrata->vrijednost,
            'links'=> [
                'self' =>'/_brojVrata/' .$_brojVrata->id
            ]
            ];
        });
        return $fractal->createData($resource)->toJson();
    }

    public function getEmisionaKlasa()
    {
        $fractal = new Manager();
        $emisionaKlase = EmisionaKlasa::all();

        $resource = new Fractal\Resource\Collection($emisionaKlase, function (EmisionaKlasa $emisionaKlasa){
            return [
            'id'=> (int)$emisionaKlasa->id,
            'vrijednost'=>(string)$emisionaKlasa->vrijednost,
            'links'=> [
                'self' =>'/emisionaKlasa/' .$emisionaKlasa->id
            ]
            ];
        });
        return $fractal->createData($resource)->toJson();
    }

    public function getGodinaProizvodnje()
    {
        $fractal = new Manager();
        $godineProizvodnje = GodinaProizvodnje::all();

        $resource = new Fractal\Resource\Collection($godineProizvodnje, function (godinaProizvodnje $godinaProizvodnje){
            return [
            'id'=> (int)$godinaProizvodnje->id,
            'vrijednost'=>(string)$godinaProizvodnje->vrijednost,
            'links'=> [
                'self' =>'/godinaProizvodnje/' .$godinaProizvodnje->id
            ]
            ];
        });
        return $fractal->createData($resource)->toJson();
    }

    public function getIdVrstaOglasa()
    {
        $fractal = new Manager();
        $idVrstaOglasa = IdVrstaOglasa::all();

        $resource = new Fractal\Resource\Collection($idVrstaOglasa, function (IdVrstaOglasa $idVrstaOglasa){
            return [
            'id'=> (int)$idVrstaOglasa->id,
            'vrijednost'=>(string)$idVrstaOglasa->vrijednost,
            'links'=> [
                'self' =>'/idVrstaOglasa/' .$idVrstaOglasa->id
            ]
            ];
        });
        return $fractal->createData($resource)->toJson();
    }

    public function getKaroserija()
    {
        $fractal = new Manager();
        $karoserije = Karoserija::all();

        $resource = new Fractal\Resource\Collection($karoserije, function (Karoserija $karoserija){
            return [
            'id'=> (int)$karoserija->id,
            'vrijednost'=>(string)$karoserija->vrijednost,
            'links'=> [
                'self' =>'/karoserija/' .$karoserija->id
            ]
            ];
        });
        return $fractal->createData($resource)->toJson();
    }

    public function getKlima()
    {
        $fractal = new Manager();
        $klime = Klima::all();

        $resource = new Fractal\Resource\Collection($klime, function (Klima $klima){
            return [
            'id'=> (int)$klima->id,
            'vrijednost'=>(string)$klima->vrijednost,
            'links'=> [
                'self' =>'/klima/' .$klima->id
            ]
            ];
        });
        return $fractal->createData($resource)->toJson();
    }

    public function getMaterijalEnterijera()
    {
        $fractal = new Manager();
        $materijaliEnterijera = MaterijalEnterijera::all();

        $resource = new Fractal\Resource\Collection($materijaliEnterijera, function (MaterijalEnterijera $materijalEnterijera){
            return [
            'id'=> (int)$materijalEnterijera->id,
            'vrijednost'=>(string)$materijalEnterijera->vrijednost,
            'links'=> [
                'self' =>'/materijalEnterijera/' .$materijalEnterijera->id
            ]
            ];
        });
        return $fractal->createData($resource)->toJson();
    }

    public function getMenjac()
    {
        $fractal = new Manager();
        $menjaci = Menjac::all();

        $resource = new Fractal\Resource\Collection($menjaci, function (Menjac $menjac){
            return [
            'id'=> (int)$menjac->id,
            'vrijednost'=>(string)$menjac->vrijednost,
            'links'=> [
                'self' =>'/menjac/' .$menjac->id
            ]
            ];
        });
        return $fractal->createData($resource)->toJson();
    }

    public function getOstecenje()
    {
        $fractal = new Manager();
        $ostecenja = Ostecenje::all();

        $resource = new Fractal\Resource\Collection($ostecenja, function (Ostecenje $ostecenje){
            return [
            'id'=> (int)$ostecenje->id,
            'vrijednost'=>(string)$ostecenje->vrijednost,
            'links'=> [
                'self' =>'/ostecenje/' .$ostecenje->id
            ]
            ];
        });
        return $fractal->createData($resource)->toJson();
    }

    public function getPogon()
    {
        $fractal = new Manager();
        $pogoni = Pogon::all();

        $resource = new Fractal\Resource\Collection($pogoni, function (Pogon $pogon){
            return [
            'id'=> (int)$pogon->id,
            'vrijednost'=>(string)$pogon->vrijednost,
            'links'=> [
                'self' =>'/pogon/' .$pogon->id
            ]
            ];
        });
        return $fractal->createData($resource)->toJson();
    }

    public function getPoreklo()
    {
        $fractal = new Manager();
        $porekla = Poreklo::all();

        $resource = new Fractal\Resource\Collection($porekla, function (Poreklo $poreklo){
            return [
            'id'=> (int)$poreklo->id,
            'vrijednost'=>(string)$poreklo->vrijednost,
            'links'=> [
                'self' =>'/poreklo/' .$poreklo->id
            ]
            ];
        });
        return $fractal->createData($resource)->toJson();
    }

    public function getStranaVolana()
    {
        $fractal = new Manager();
        $straneVolana = StranaVolana::all();

        $resource = new Fractal\Resource\Collection($straneVolana, function (StranaVolana $stranaVolana){
            return [
            'id'=> (int)$stranaVolana->id,
            'vrijednost'=>(string)$stranaVolana->vrijednost,
            'links'=> [
                'self' =>'/stranaVolana/' .$stranaVolana->id
            ]
            ];
        });
        return $fractal->createData($resource)->toJson();
    }

    public function getTipVozila()
    {
        $fractal = new Manager();
        $tipoviVozila = TipVozila::all();

        $resource = new Fractal\Resource\Collection($tipoviVozila, function (TipVozila $tipVozila){
            return [
            'id'=> (int)$tipVozila->id,
            'vrijednost'=>(string)$tipVozila->vrijednost,
            'links'=> [
                'self' =>'/tipVozila/' .$tipVozila->id
            ]
            ];
        });
        return $fractal->createData($resource)->toJson();
    }

    public function getZamena()
    {
        $fractal = new Manager();
        $zamene = Zamena::all();

        $resource = new Fractal\Resource\Collection($zamene, function (Zamena $zamena){
            return [
            'id'=> (int)$zamena->id,
            'vrijednost'=>(string)$zamena->vrijednost,
            'links'=> [
                'self' =>'/zamena/' .$zamena->id
            ]
            ];
        });
        return $fractal->createData($resource)->toJson();
    }

    public function getGorivo()
    {
        $fractal = new Manager();
        $goriva = Gorivo::all();

        $resource = new Fractal\Resource\Collection($goriva, function (Gorivo $gorivo){
            return [
            'id'=> (int)$gorivo->id,
            'vrijednost'=>(string)$gorivo->vrijednost,
            'links'=> [
                'self' =>'/gorivo/' .$gorivo->id
            ]
            ];
        });
        return $fractal->createData($resource)->toJson();
    }

    public function getRegistracija()
    {
        $fractal = new Manager();
        $registracije = Registracija::all();

        $resource = new Fractal\Resource\Collection($registracije, function (Registracija $registracija){
            return [
            'id'=> (int)$registracija->id,
            'vrijednost'=>(string)$registracija->vrijednost,
            'links'=> [
                'self' =>'/registracija/' .$registracija->id
            ]
            ];
        });
        return $fractal->createData($resource)->toJson();
    }

}
