<?php

namespace App\Http\Controllers;

use App\Title;
use App\Http\Requests\AddNewTitleRequest;
use App\Http\Requests\UpdateTitleRequest;
use http\Env\Request;
use League\Fractal;
use League\Fractal\Manager;


class TitleController extends Controller
{    /**
     *
     */
    public function index()
    {
        $fractal = new Manager();
        $titles = Title::all();

        $resource = new Fractal\Resource\Collection($titles, function (Title $title) {

            return [
                'id' => (string)$title->id,
                'text' => (string)$title->text,
                'subtext' => (string)$title->subtext,
                'isTitle' => (boolean)$title->isTitle,
                'links' => [
                    'self' => '/title/' . $title->id,
                ]
            ];
        });

        return $fractal->createData($resource)->toJson();
    }

    /**
     *
     */
    public function create(AddNewTitleRequest $request)
    {   
        $fractal = new Manager();
        $title = new Title;
        $title->text = (string) $request->text;
        $title->subtext = (string) $request->subtext;
        $title->isTitle = (boolean) $request->isTitle;
        
        $title->save();

      
    }

    /**
     *
     */
    public function update(UpdateTitleRequest $request, $id)
    {   
        $title = Title::find($id);
       
        $array = $request->toArray();
       
        foreach($array as $key=>$value){
            $title->$key = $value;
        }


        $title->save();
    }

    /**
     *
     */
    public function destroy($id)
    {
        Title::where('id', $id)->delete();
    }

    /**
     *
     */
}
