<?php

namespace App\Http\Controllers;

use App\Car;
use App\Brand;
use App\Http\Requests\AddNewCarRequest;
use App\Http\Requests\UpdateCarRequest;
use http\Env\Request;
use League\Fractal;
use League\Fractal\Manager;


class CarController extends Controller
{
    /**
     *
     */
    public function index()
    {
        $fractal = new Manager();
        $cars = Car::all();

        $resource = new Fractal\Resource\Collection($cars, function (Car $car) {

            return [
                'id_vozila' => (string)$car->id_vozila,
                'tip_vozila' => (string)$car->tip_vozila, 
                'status' => (string)$car->status,
                'marka' => (string)$car->marka,
                'model' => (string)$car->model,
                'godina_proizvodnje' => (string)$car->godina_proizvodnje,
                'karoserija' => (string)$car->karoserija,
                'kubikaza' => (int)$car->kubikaza,
                'gorivo' => (string)$car->gorivo,
                'snaga_kw' => (int)$car->snaga_kw,
                'snaga_ks' => (int)$car->snaga_ks,
                'kilometraza' => (int)$car->kilometraza,
                'emisiona_klasa' => (string)$car->emisiona_klasa,
                'pogon' => (string)$car->pogon,
                'menjac' => (string)$car->menjac,
                'broj_vrata' => (string)$car->broj_vrata,
                'broj_sedista' => (string)$car->broj_sedista,
                'klima' => (string)$car->klima,
                'boja' => (string)$car->boja,
                'registracija' => (string)$car->registracija,
                'ostecenje' => (string)$car->ostecenje,
                'poreklo' => (string)$car->poreklo,
                'obelezje' => (string)$car->obelezje,
                'strana_volana' => (string)$car->strana_volana,
                'materijal_enterijera' => (string)$car->materijal_enterijera,
                'boja_enterijera' => (string)$car->boja_enterijera,
                'zamena' => (string)$car->zamena,
                'idVrstaOglasa' => (string)$car->idVrstaOglasa,
                'airbagZaVozaca' => (string)$car->airbagZaVozaca,
                'centralnoZakljucavanje' => (string)$car->centralnoZakljucavanje,
                'esp' => (string)$car->esp,
                'abs' => (string)$car->abs,
                'childLock' => (string)$car->childLock,
                'senzoriZaSvetla' => (string)$car->senzoriZaSvetla,
                'elektricniPodizaci' => (string)$car->elektricniPodizaci,
                'elektricniRetrovizori' => (string)$car->elektricniRetrovizori,
                'sedistaPodesivaPoVisini' => (string)$car->sedistaPodesivaPoVisini,
                'multifunkcionalniVolan' => (string)$car->multifunkcionalniVolan,
                'putniRacunar' => (string)$car->putniRacunar,
                'tempomat' => (string)$car->tempomat,
                'putniRacunar' => (string)$car->putniRacunar,
                'parkingSenzori' => (string)$car->parkingSenzori,
                'RadioCD' => (string)$car->RadioCD,
                'bluetooth' => (string)$car->bluetooth,
                'navigacija1' => (string)$car->navigacija1,
                'prodajaNaKredit' => (string)$car->prodajaNaKredit,
                'lizing' => (string)$car->lizing,
                'servisnaKnjiga' => (string)$car->servisnaKnjiga,
                'garancija' => (string)$car->garancija,
                'prviVlasnik' => (string)$car->prviVlasnik,
                'slike' => (string)$car->slike,
                'cena' => (string)$car->cena
            ];
        });

        return $fractal->createData($resource)->toJson();
    }

    /**
     *
     */
    public function create(AddNewCarRequest $request)
    {
        $fractal = new Manager();
        $car = new Car();        

        $data = $request->all();

        foreach ($data as $key=>$value)
        {

            if($key == 'slike') {
                $value = implode(";", $value);
                $car->slike = $value;
            }

            else 
            {
                $car->$key = $value;
            }


        }
         $car->save();
    }

    /**
     *
     */
    public function update(UpdateCarRequest $request, $id_vozila)
    {   
        
        $car = Car::find($id_vozila);

        $array = $request->toArray();
       
        
        foreach($array as $key=>$value){
            if($key == 'slike') {
                $value = implode(";", $value);
                $car->slike = $value;
            }
            else 
            {
                $car->$key = $value;
            }
        }

        $car->save();
    }

    /**
     *
     */
    public function destroy($id_vozila)
    {
        Car::where('id_vozila', $id_vozila)->delete();
    }
}
