<?php

use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/
Route::get('cars','CarController@index');
Route::get('brands','CarController@getBrands');
Route::get('pictures','PictureController@index');
Route::get('titles','TitleController@index');


Route::post('email','EmailController@email');
Route::post('serviceEmail','EmailController@serviceEmail');
Route::post('serviceCompanyEmail','EmailController@serviceCompanyEmail');

Route::post('register', 'AuthController@register');
Route::post('login', 'AuthController@login');
Route::post('recover', 'AuthController@recover');
Route::group(['middleware' => ['jwt.auth']], function() {
    Route::post('pictures','PictureController@create');
    Route::post('cars', 'CarController@create');
    Route::post('titles', 'TitleController@create');
    Route::put('cars/{id_vozila}', 'CarController@update');
    Route::delete('cars/{id_vozila}', 'CarController@destroy');
    Route::put('pictures/{id}', 'PictureController@update');
    Route::delete('pictures/{id}', 'PictureController@destroy');
    Route::put('titles/{id}', 'TitleController@update');
    Route::delete('titles/{id}', 'TitleController@destroy');
    Route::get('logout', 'AuthController@logout');

    Route::get('marka','sifarniciController@getMarka');
    Route::get('model','sifarniciController@getModel');
    Route::get('markaModel', 'sifarniciController@getMarkaModel');
    Route::get('boja','sifarniciController@getBoja');
    Route::get('bojaEnterijera','sifarniciController@getBojaEnterijera');
    Route::get('brojSedista','sifarniciController@getBrojSedista');
    Route::get('brojVrata','sifarniciController@getBrojVrata');
    Route::get('emisionaKlasa','sifarniciController@getEmisionaKlasa');
    Route::get('godinaProizvodnje','sifarniciController@getGodinaProizvodnje');
    Route::get('gorivo','sifarniciController@getGorivo');
    Route::get('idVrstaOglasa','sifarniciController@getIdVrstaOglasa');
    Route::get('karoserija','sifarniciController@getKaroserija');
    Route::get('klima','sifarniciController@getKlima');
    Route::get('materijalEnterijera','sifarniciController@getMaterijalEnterijera');
    Route::get('menjac','sifarniciController@getMenjac');
    Route::get('ostecenje','sifarniciController@getOstecenje');
    Route::get('pogon','sifarniciController@getPogon');
    Route::get('poreklo','sifarniciController@getPoreklo');
    Route::get('stranaVolana','sifarniciController@getStranaVolana');
    Route::get('tipVozila','sifarniciController@getTipVozila');
    Route::get('zamena','sifarniciController@getZamena');
    Route::get('registracija','sifarniciController@getRegistracija');

    Route::get('test', function(){
        return response()->json(['foo'=>'bar']);
    });
});

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});