<?php

namespace App\Http\Controllers;

use App\Picture;
use App\Http\Requests\AddNewPictureRequest;
use App\Http\Requests\UpdatePictureRequest;
use http\Env\Request;
use League\Fractal;
use League\Fractal\Manager;


class PictureController extends Controller
{    /**
     *
     */
    public function index()
    {
        $fractal = new Manager();
        $pictures = Picture::all();

        $resource = new Fractal\Resource\Collection($pictures, function (Picture $picture) {

            return [
                'id' => (string)$picture->id,
                'image' => (string)$picture->image,
                'isBackground' => (boolean)$picture->isBackground,
                'links' => [
                    'self' => '/picture/' . $picture->id,
                ]
            ];
        });

        return $fractal->createData($resource)->toJson();
    }

    /**
     *
     */
    public function create(AddNewPictureRequest $request)
    {   
        $fractal = new Manager();
        $picture = new Picture;
        $picture->image = (string) $request->image;
        $picture->isBackground = (boolean) $request->isBackground;
        
        $picture->save();

      
    }

    /**
     *
     */
    public function update(UpdatePictureRequest $request, $id)
    {   
        $picture = Picture::find($id);
       
        $array = $request->toArray();
       
        foreach($array as $key=>$value){
            $picture->$key = $value;
        }


        $picture->save();
    }

    /**
     *
     */
    public function destroy($id)
    {
        Picture::where('id', $id)->delete();
    }

    /**
     *
     */
}
