<?php

namespace App\Http\Controllers;

use App\Car;
use App\Brand;
use App\Http\Requests\AddNewCarRequest;
use App\Http\Requests\UpdateCarRequest;
use http\Env\Request;
use League\Fractal;
use League\Fractal\Manager;


class CarController extends Controller
{

    public function getBrands()
    {
        $fractal = new Manager();
        $brands = Brand::all();

        $resource = new Fractal\Resource\Collection($brands, function (Brand $brand) {
            return [
                'id' => (string)$brand->id,
                'name' => (string)$brand->name,
                'links' => [
                    'self' => '/brand/' . $brand->id,
                ]
            ];
        });

        return $fractal->createData($resource)->toJson();
    }


    /**
     *
     */
    public function index()
    {
        $fractal = new Manager();
        $cars = Car::all();

        $resource = new Fractal\Resource\Collection($cars, function (Car $car) {

            return [
                'id' => (string)$car->id,
                'brand' => Brand::where('id', $car->brand_id)->pluck('name')[0],
                'model' => (string)$car->model,
                'year' => (string)$car->year,
                'engine' => (string)$car->engine,
                'kmeter' => (string)$car->kmeter,
                'price' => (string)$car->price,
                'image' => (string)$car->image,
                'used' => (boolean)$car->used,
                'featured' => (boolean)$car->featured,
                'sold' => (boolean)$car->sold,
                'text' => (string)$car->text,
                'links' => [
                    'self' => '/car/' . $car->id,
                ]
            ];
        });

        return $fractal->createData($resource)->toJson();
    }

    /**
     *
     */
    public function create(AddNewCarRequest $request)
    {
        $fractal = new Manager();
        $car = new Car;
		if($request->brand=='Škoda'){
			$car->brand_id=0;
		}
        if($request->brand=='Ford'){
            $car->brand_id = 1;
        }
        if ($request->brand=='Infiniti') {
            $car->brand_id = 2;
        }
        if ($request->brand=='SsangYong') {
            $car->brand_id = 3;
        }
		if ($request->brand=='Volvo') {
            $car->brand_id = 4;
        }
		if ($request->brand=='Mazda') {
            $car->brand_id = 5;
        }
		if ($request->brand=='Audi') {
            $car->brand_id = 6;
        }
		if ($request->brand=='Renault') {
            $car->brand_id = 7;
        }
		if ($request->brand=='Volkswagen') {
            $car->brand_id = 8;
        }
		if ($request->brand=='Hyundai') {
            $car->brand_id = 9;
        }
		if ($request->brand=='Citroen') {
            $car->brand_id = 10;
        }
		if ($request->brand=='Opel') {
            $car->brand_id = 11;
        }
		if ($request->brand=='Mercedes-Benz') {
            $car->brand_id = 12;
        }
		if ($request->brand=='Peugeot') {
            $car->brand_id = 13;
        }
		if ($request->brand=='Maserati') {
            $car->brand_id = 14;
        }
		if ($request->brand=='BMW') {
            $car->brand_id = 15;
        }
		if ($request->brand=='Toyota') {
            $car->brand_id = 16;
        }
        $car->model = (string) $request->model;
        $car->year = (string) $request->year;
        $car->engine = (string) $request->engine;
        $car->kmeter = (string) $request->kmeter;
        $car->price = (string) $request->price;
        $car->image = (string) $request->image;
        $car->used = (boolean) $request->used;
        $car->featured = (boolean) $request->featured;
        $car->sold = (boolean) $request->sold;
        $car->text = (string) $request->text;
        
        $car->save();

        // return $fractal->createData($resource)->toJson();
    }

    /**
     *
     */
    public function update(UpdateCarRequest $request, $id)
    {   
        $car = Car::find($id);
       
        $array = $request->toArray();
       
        foreach($array as $key=>$value){
            $car->$key = $value;
        }


        $car->save();
    }

    /**
     *
     */
    public function destroy($id)
    {
        Car::where('id', $id)->delete();
    }

    /**
     *
     */
    public function filter(Request $request)
    {
        $fractal = new Manager();
        $cars = Car::all();

        $resource = new Fractal\Resource\Collection($cars, function (Car $car) {
            return [
                'brand_id' => (string)$car->brand,
                'model' => (string)$car->model,
                'year' => (string)$car->year,
                'engine' => (string)$car->engine,
                'kmeter' => (string)$car->kmeter,
                'price' => (string)$car->price,
                'image' => (string)$car->image,
                'links' => [
                    'self' => '/car/' . $car->id,
                ]
            ];
        });

        return $fractal->createData($resource)->toJson();
    }
}
